/*
f[^x[Xobt@LbṼqbg擾

interval_secϐŐݒ肵ԊuŁAv$sysstatl2擾A
̍擾邱ƂŃqbgvZ܂B
*/
declare
	-- 肷鎞ԂbPʂŎw
	interval_sec	number := 10;

	-- v$sysstat̒lێ邽߂̘Azz`
	type sysstat_type is table of v$sysstat.value%type index by v$sysstat.name%type;

	-- v$systatf[^擾
	function get_stat return sysstat_type is
		stat	sysstat_type;
		cursor c1 is
			select s.name, s.value
			from v$sysstat s
			where s.name in (
				'physical reads cache', 
				'db block gets from cache', 
				'consistent gets from cache');
	begin
		for c1_rec in c1 loop
			stat(c1_rec.name) := c1_rec.value;
		end loop;
		return stat;
	end;

	-- v$sysstat̍vZ
	function calc_stat_delta(stat1_in in sysstat_type, stat2_in in sysstat_type)
		return sysstat_type is
		delta	sysstat_type;
		key		v$sysstat.name%type;
	begin
		key := stat1_in.first;
		loop
			exit when(key is null);
			delta(key) := stat2_in(key) - stat1_in(key);
			key := stat1_in.next(key);
		end loop;

		return delta;
	end;

	-- db block hit ratio𑪒肷
	procedure measure_db_block_hit_ratio(interval_sec_in in number) is
		stat1		sysstat_type;
		stat2		sysstat_type;
		stat_delta	sysstat_type;
		db_block_hit_ratio	number;
		block_gets	number;
		tm1			timestamp;
		tm2			timestamp;
	begin
		-- v$sysstat1ڂ̎擾
		select systimestamp into tm1 from dual;
		stat1 := get_stat();

		-- w肳ꂽsleep
		dbms_session.sleep(interval_sec_in);

		-- v$sysstat2ڂ̎擾
		select systimestamp into tm2 from dual;
		stat2 := get_stat();
	
		-- vZ
		stat_delta := calc_stat_delta(stat1, stat2);
	
		-- obt@LbVւ̗v񐔂vZ
		block_gets := stat_delta('consistent gets from cache') + stat_delta('db block gets from cache');

		-- block_gets0̏ꍇA0ŊZȂ悤ɂ
		if block_gets = 0 then block_gets := 1; end if;

		-- qbgvZ
		db_block_hit_ratio := 1 - (stat_delta('physical reads cache') / block_gets);
	
		-- ʂo
		dbms_output.put_line(
			to_char(tm1, 'YYYY/MM/DD HH24:MI:SS') || ' - ' ||
			to_char(tm2, 'YYYY/MM/DD HH24:MI:SS'));
		dbms_output.put_line(
			'db block hit ratio: ' ||
			to_char(db_block_hit_ratio * 100, '999.99') || '%');
		dbms_output.put_line(
			'physical reads cache: ' || stat_delta('physical reads cache'));
		dbms_output.put_line(
			'consistent gets from cache: ' || stat_delta('consistent gets from cache'));
		dbms_output.put_line(
			'db block gets from cache: ' || stat_delta('db block gets from cache'));
	end;

begin
	measure_db_block_hit_ratio(interval_sec);
end;

