/* \̈̎gp擾
	tablespace_name: \̈於
	tablespace_kbytes \̈TCY(KB)
	used_kbytes gpς݂̗̈(KB)
	free_kbytes 󂫗̈(KB)
	capacity: gp(%)
*/
select z.tablespace_name, 
	bytes / 1024 tablespace_kbytes,
	(bytes - free_bytes) / 1024 used_kbytes,
	free_bytes / 1024 free_kbytes,
	to_char(((bytes - free_bytes) / (max_bytes)) * 100, '990.99') || '%' capacity
from 
	(select df.tablespace_name, sum(df.bytes) bytes, sum(f.free_bytes) free_bytes,
	        sum(decode(df.autoextensible, 'YES', df.maxbytes, df.bytes)) max_bytes
	from dba_data_files df,
	        (select file_id, sum(bytes) free_bytes
	        from dba_free_space
	        group by file_id) f
	where df.file_id = f.file_id
	group by df.tablespace_name) z
order by tablespace_name;

